
/**
 ******************************************************************************
 *
 * @file        MG32_USBD_MGData.h
 * @brief       The code is Megawin AP TX/RX data H file.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32.h"
#include "MG32_USB_Init.h"
#include "MG32_USBD_Descriptor.h"
#include "MG32_USBD_Core.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
//============================================================
typedef struct
{
    uint8_t               Status;
    uint8_t               RX_Index;
    uint8_t               AP_Connect;
    uint8_t               __Reserved;
    uint32_t              RX_Total;
}MGData_TypeDef;

/* Private define ------------------------------------------------------------*/
//============================================================
#define MGDATA_CMD_DATA                     0x01
    #define MDDATA_SCMD_DATA                    0x00

#define MGDATA_CMD_READ_APSTATUS            0x06
    #define MGDATA_SCMD_READ_CALENDAR           0x02
    
#define MGDATA_CMD_HOST_CMD                 0xFF
    #define MGDATA_SCMD_HOST_SYNC               0x01
    #define MGDATA_SCMD_HOST_DOWNLOAD           0xDD                    

//============================================================
#define MGDATA_SUCCESS                      0
#define MGDATA_FAILURE                      1

#define MGDATA_CTRTYPE_MASK                 0xF0
#define MGDATA_CTRTYPE_IDLE                 0x00
#define MGDATA_CTRTYPE_HOSTDOWNLOAD         0x20
#define MGDATA_CTRTYPE_CALENDAR_UPDATE      0x40

#define MGDATA_CTRSTATUS_MASK               0x0F
#define MGDATA_CTRSTATUS_IDLE               0x00
#define MGDATA_CTRSTATUS_RY                 0x01
#define MGDATA_CTRSTATUS_DATA               0x02
#define MGDATA_CTRSTATUS_RY_DATA            0x03
#define MGDATA_CTRSTATUS_COMPLETE           0x08

//============================================================
#define MGDATA_CALENDAR_YEAR_BYTE0          0
#define MGDATA_CALENDAR_YEAR_BYTE1          1
#define MGDATA_CALENDAR_MONTH               2
#define MGDATA_CALENDAR_DAY                 3
#define MGDATA_CALENDAR_HOUR                4
#define MGDATA_CALENDAR_MINUTE              5
#define MGDATA_CALENDAR_SECOND              6

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void USB_MGCTR_Init(void);
void USB_MGCTR_GetFeatureHandle(void);
void USB_MGCTR_SetFeatureHandle(void);
uint8_t USB_MGCTR_TriggerUpdateCalendar(void);

void USB_MGCTR_UpdateCalendarCallback(uint8_t *CalendarData);
void USB_MGCTR_HostDownloadReadyCallback( uint8_t HostDL_Index , uint32_t HostDL_TotalSize);
void USB_MGCTR_HostDownloadContinuousCallback( uint8_t* HostDLBuf , uint8_t HostDL_BLen);
void USB_MGCTR_HostDownloadCompleteCallback(uint8_t* HostDLBuf , uint8_t HostDL_BLen);

void USB_MGCTR_ErrorUpdateCalendar(void);
void USB_MGCTR_ErrorCommandCallback(void);
void USB_MGCTR_ErrorSubCommandCallback(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
extern MGData_TypeDef     MGData_CTR;


